/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 2.6.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2004,2005,2006,2007,2008,2009 COLLARD Christophe
 * copyright © 2004,2005,2006,2007,2008,2009 Centre National de la Recherche Scientifique
 * copyright © 2004,2005,2006,2007,2008,2009 Arts et Métiers ParisTech
 * copyright © 2004,2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2004,2005,2006,2007,2008,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2004,2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 ***************************************************************/

/*
    combinatorial analystis-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for combinatorial analysis-test
#endif

#if !defined (__COMBINATORIAL_ANALYSIS_TEST_H)
#define _combinatorial_analysis_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__ASSERT_H)
#include <time.h>
#endif

#if !defined(__COLORS_H)
#include "colors.h"
#endif

#if !defined(__VECTORS_H)
#include "MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include "MOL++/matrix.h"
#endif

#if !defined(__COMBINATORIAL_ANALYSIS_H)
#include "MOL++/combinatorial analysis.h"
#endif

#if !defined(__AFFICHE_h)
#include "tests/affiche.h"
#endif

using namespace mol;


//==========================================
int test_combinatorial_analysis (int detail)
//==========================================
{
  int result=1;

  if (detail) affiche ("Cnp", Cnp(24,6)==134596 && Cnp(24,1)==24);
  else result *= (Cnp(24,6)==134596 && Cnp(24,1)==24);

  vector<int> v(7);
  for (int i=1; i<=7; i++)
    v[i] = i;
  matrix <int> mat(21,5);
  mat(1,1)=5; mat(1,2)=4; mat(1,3)=3; mat(1,4)=2; mat(1,5)=1;
  mat[2] = mat[1];  mat(2,1) = 6;
  mat[3] = mat[1];  mat(3,1) = 7;
  mat[4] = mat[1];  mat(4,1) = 6;  mat(4,2) = 5;
  mat[5] = mat[4];  mat(5,1) = 7;
  mat[6] = mat[5];  mat(6,2) = 6;
  mat[7] = mat[4];  mat(7,3) = 4;
  mat[8] = mat[7];  mat(8,1) = 7;
  mat[9] = mat[8];  mat(9,2) = 6;
  mat[10] = mat[9]; mat(10,3) = 5;
  mat[11] = mat[7]; mat(11,4) = 3;
  mat[12] = mat[11]; mat(12,1) = 7;
  mat[13] = mat[12]; mat(13,2) = 6;
  mat[14] = mat[13]; mat(14,3) = 5;
  mat[15] = mat[14]; mat(15,4) = 4;
  mat[16] = mat[11]; mat(16,5) = 2;
  mat[17] = mat[16]; mat(17,1) = 7;
  mat[18] = mat[17]; mat(18,2) = 6;
  mat[19] = mat[18]; mat(19,3) = 5;
  mat[20] = mat[19]; mat(20,4) = 4;
  mat[21] = mat[20]; mat(21,5) = 3;
  if (detail) affiche ("combinations", mat==combinations (5,v));
  else result *= (mat==combinations (5,v));

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout << green << "            combinatorial analysis test passed" << reset;
  else cout << red << "            combinatorial analysis test failed" << reset;
  cout << "============================================================== \n";
  return result;
}


#endif
